//
// LocalSolver Model for Example 6.4
//

use io;

function input() 
{
  // read data from .dat file
  dataFile = io.openRead("Example6.4.dat");
  facilities = dataFile.readInt();
  customers = dataFile.readInt();
  revenue[i in 1..facilities][j in 1..customers] = dataFile.readInt();
  resources[i in 1..facilities][j in 1..customers] = dataFile.readInt();
  demand[i in 1..facilities][j in 1..customers] = dataFile.readInt();
  capacity[i in 1..facilities] = dataFile.readInt();
  cost[i in 1..facilities] = dataFile.readInt();
  dataFile.close();
}

function model()
{
  // x[i][j] = 1 if customer i assigned to facility j and 0 otherwise
  x[i in 1..facilities][j in 1..customers] <- bool();
  
  // resource capacity should not be exceeded
  for[i in 1..facilities] 
    constraint sum[j in 1..customers] (resources[i][j]*x[i][j]) <= capacity[i];

  // customers must be assigned to one facility
  for[j in 1..customers] 
    constraint sum[i in 1..facilities] (x[i][j]) == 1;

  // objective function is profit
  totalrevenue <- sum[i in 1..facilities][j in 1..customers] (revenue[i][j]*x[i][j]);
  for[i in 1..facilities] 
  	sqrtdemand[i] <- sqrt(sum[j in 1..customers] (demand[i][j]*x[i][j]));
  totalcost <- sum[i in 1..facilities] (cost[i]*sqrtdemand[i]);
  profit <- totalrevenue - totalcost;
  maximize profit;
}

function output() 
{
  // write output file
  outputFile = io.openWrite("Example6.4.out");
  for[i in 1..facilities] {
    for[j in 1..customers] 
      outputFile.print(" " + getValue(x[i][j]));
    outputFile.println();
  }
  outputFile.close();
}